package gov.va.med.mhv.usermgmt.service;

import gov.va.med.mhv.usermgmt.enumeration.AuthenticationStatus;
import gov.va.med.mhv.usermgmt.enumeration.GenderEnumeration;
import gov.va.med.mhv.usermgmt.service.delegate.EntityMaintenanceServiceDelegate;
import gov.va.med.mhv.usermgmt.service.delegate.FacilityServiceDelegate;
import gov.va.med.mhv.usermgmt.service.delegate.InPersonAuthenticationServiceDelegate;
import gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory;
import gov.va.med.mhv.usermgmt.transfer.Facility;
import gov.va.med.mhv.usermgmt.transfer.FacilityInfo;
import gov.va.med.mhv.usermgmt.transfer.InPersonAuthentication;
import gov.va.med.mhv.usermgmt.transfer.Patient;
import gov.va.med.mhv.usermgmt.transfer.UserProfile;
import gov.va.med.mhv.usermgmt.service.ConcreteFactory;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.tigris.atlas.service.EntityServiceResponse;

public class AbstractIPATest extends BaseTestCase {
	protected InPersonAuthenticationServiceDelegate sDelegate;
	protected EntityMaintenanceServiceDelegate emDelegate;
	protected FacilityServiceDelegate fDelegate;
	protected List<Patient> patients;
	protected List<InPersonAuthentication> ipaObjects;
	protected List<FacilityInfo> facilityInfos;
	
	protected void setUp() throws Exception {
		super.setUp();
		patients = new ArrayList<Patient>();
		ipaObjects = new ArrayList<InPersonAuthentication>();
		facilityInfos = new ArrayList<FacilityInfo>();
		
		setupDelegates();
		setupFacilities();
		setupPatients();
	}

	protected void tearDown() throws Exception {
		//TODO: Improve resliency of tearDowns by detecting incomplete setup and continuing upon error
		super.tearDown();
		tearDownPatients();
		tearDownFacilities();
	}
	
	
	private void setupDelegates() {
		sDelegate = ServiceDelegateFactory.createInPersonAuthenticationServiceDelegate();
		fDelegate = ServiceDelegateFactory.createFacilityServiceDelegate();
		emDelegate = gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory.createEntityMaintenanceServiceDelegate();		
	}
	
	private void setupFacilities() {
		FacilityInfo facilityInfo1 = createFacilityInfo("Orbit City General", "OCG");
		facilityInfos.add(facilityInfo1);
		FacilityInfo facilityInfo2 = createFacilityInfo("Space Age Medical Center", "SAMC");
		facilityInfos.add(facilityInfo2);
	}
	
	private void tearDownFacilities() {
		EntityServiceResponse response;
		
		for(FacilityInfo f : facilityInfos){
			response = getUserEntityDelegate().delete(f.getFacilityInfoPK());
			assertFalse(getErrors(response), hasErrors(response));
		}
	}
	
	private void setupPatients() {
		Calendar cal = Calendar.getInstance();
		cal.set(1960, 01, 01);
		Math.random();
		UserProfile userProfile = createUserProfile("George", "Jetson", "gj0001", "484-94-0001", cal.getTime(), 
				GenderEnumeration.getEnum(GenderEnumeration.MALE), Boolean.TRUE, Boolean.TRUE);
		Patient patient = createPatient("george01", userProfile, facilityInfos.get(0));
		patients.add(patient);
		
		UserProfile userProfile2 = createUserProfile("Joe", "Crabshack", "jc0001", "484-94-2342", cal.getTime(), 
				GenderEnumeration.getEnum(GenderEnumeration.MALE), Boolean.TRUE, Boolean.TRUE);
		Patient patient2 = createPatient("joe01", userProfile2, facilityInfos.get(1));
		patients.add(patient2);
		
		UserProfile userProfile3 = createUserProfile("Gerald", "Ford", "bw0001", "484-94-2343", cal.getTime(), 
				GenderEnumeration.getEnum(GenderEnumeration.FEMALE), Boolean.TRUE, Boolean.TRUE);
		Patient patient3 = createPatient("betty01", userProfile3, facilityInfos.get(1));
		patients.add(patient3);
	}

	private void tearDownPatients() {
		EntityServiceResponse response;
		for(Patient p : patients){
			response = getUserEntityDelegate().delete(p.getPatientPK());
			assertFalse(getErrors(response), hasErrors(response));
			
			response = getUserEntityDelegate().delete(p.getUserProfile().getUserProfilePK());
			assertFalse(getErrors(response), hasErrors(response));
		}
	}

	protected FacilityInfo createFacilityInfo(String name, String stationNumber) {
		FacilityInfoServiceResponse response = ConcreteFactory.createFacilityInfo(name, stationNumber);
		assertFalse(getErrors(response), hasErrors(response));
		
		FacilityInfo fi = response.getFacilityInfo();
		assertNotNull(fi);
		assertNotNull(fi.getId());
		
		return fi;
	}
	
	protected InPersonAuthentication createInPersonAuthentication(Patient patient, FacilityInfo authenticatingFacility, AuthenticationStatus status){
		InPersonAuthenticationServiceResponse resp = ConcreteFactory.createIPA(patient, authenticatingFacility, status);
		assertFalse(getErrors(resp), hasErrors(resp));
		
		InPersonAuthentication ipa = resp.getInPersonAuthentication();
		assertNotNull(ipa);
		assertNotNull(ipa.getId());
		
		return ipa;
	}
	protected Patient createPatient(String icn, UserProfile userProfile, FacilityInfo facilityInfo) {
		
		PatientServiceResponse resp = ConcreteFactory.createPatient(icn, userProfile, facilityInfo);
		assertFalse(getErrors(resp), hasErrors(resp));
		
		Patient patient = resp.getPatient();
		assertNotNull(patient);
		assertNotNull(patient.getId());
		
		Facility f = (Facility)patient.getFacilitys().iterator().next();
		assertNotNull(f);
		assertNotNull(f.getId());
		
		return patient;
	}
	
	protected UserProfile createUserProfile(String firstName, String lastName, String userName, String ssn, Date dateOfBirth, GenderEnumeration gender, Boolean isPatient, Boolean isVeteran) {
		UserProfileServiceResponse resp = ConcreteFactory.createUserProfile(firstName, lastName, userName, ssn, dateOfBirth, gender, isPatient, isVeteran);
		assertFalse(getErrors(resp), hasErrors(resp));
		
		UserProfile userProfile = resp.getUserProfile();
		assertNotNull(userProfile);
		assertNotNull(userProfile.getId());
		
		return userProfile;
	}
	
	public gov.va.med.mhv.usermgmt.service.delegate.EntityMaintenanceServiceDelegate getUserEntityDelegate() {
		return emDelegate;
	}
	
	
}
